#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glut.h>
#include <gl\glaux.h>

#define trunc(x) ((double)((int)(x)))				// kerekts

//
// z-buffer - be
// megvilagitas - be
// textura betoltese
//
void init()
	{
	AUX_RGBImageRec *texture1;
	static GLfloat lightpos[] = {.5, .75, 1.5, 1};

	glEnable(GL_DEPTH_TEST); 
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);

	glLightfv(GL_LIGHT0, GL_POSITION, lightpos);

	texture1 = auxDIBImageLoad("../Data/glass.bmp");
	glTexImage2D(GL_TEXTURE_2D, 0, 3, texture1->sizeX, texture1->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, texture1->data);
	}

void reshape(GLsizei w, GLsizei h) 
	{
	glViewport(0, 0, w, h);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60, 1, .01, 10);
	gluLookAt(0, 0, 0, 
		 0, 0, -1, 
		 0, 1, 0);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	}

void draw_torus(GLdouble angle)
	{
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
		  GL_NEAREST);													// kicsinyites szures
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, 
		  GL_NEAREST);													// nagyitas szures
	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);	// textura generalas S -> gomb
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);	// textura generalas T -> gomb
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
	glEnable(GL_TEXTURE_2D);  
	glEnable(GL_CULL_FACE); 

	glPushMatrix();
	glTranslatef(0, 0, -3);
	glRotatef(angle, 1, 1, 0);

	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);	// textura decal mode (szincsere)

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  
	glutSolidTorus(.4, .9, 32, 32);

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	glEnable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);

	glPopMatrix();
	}
//
// az elforgatas foka az eltelt ido alapjan lesz beallitva
// 
void draw(void)
	{
	GLdouble secs, degrees;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	secs = glutGet(GLUT_ELAPSED_TIME) / 1000.0;
	secs = secs - 10.0 * trunc(secs / 10.);
	
	degrees = (secs / 10.) * (360.0);

	draw_torus(degrees);

	glutSwapBuffers();
	}
//
// ez a szokasos
// 
main(int argc, char *argv[])
	{
	glutInit(&argc, argv);
	glutInitWindowSize(256, 256);
	glutInitWindowPosition(0, 0);
	glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
	glutCreateWindow(argv[0]);
	glutDisplayFunc(draw);
	glutIdleFunc(draw); 
	glutReshapeFunc(reshape);
	init();

	glutMainLoop();
	return 0;
	}

